{ A notepad like editor which is used to view and edit the driver file. The
  form consists of a memo component which displays the driver file and buttons
  to save changes made to the drivers, choose a different driver file and close
  the window. }
unit note;
        
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TFmNote = class(TForm)
    MoDrivers: TMemo;
    Panel1: TPanel;
    BtnSaveFile: TButton;
    BtnClose: TButton;
    BtnChooseFile: TButton;
    procedure FormActivate(Sender: TObject);
    procedure BtnSaveFileClick(Sender: TObject);
    procedure BtnChooseFileClick(Sender: TObject);
    procedure BtnCloseClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FmNote: TFmNote;

implementation

{$R *.DFM}

uses stypes, frontend, fileio;

{ Set the form title and read the driver variables from the driver file into the
  memo component. }
procedure TFmNote.FormActivate(Sender: TObject);
var
 temptime : double;
 tempstring1,tempstring2 : string;
 i : integer;
begin
// Clear the memo component of old data
  MoDrivers.Lines.Clear;
// Set the form Caption
 if driverfilename = '' then
  Caption := 'Driver Variables - No driver file selected'
 else
  Caption := 'Driver Variables - ' + driverfilename;

{ Add driver names and units to the memo field even if no driver file was
   specified. This allows the creation of new driver files. }
 // Time column
 tempstring1 := format('%-26.26s',['Time']);
 tempstring2 := format('%-26.26s',[ModelDef.timeunit]);
 // Driver variable columns
 for i := 1 to ModelDef.numdrive do
  begin
   tempstring1 := tempstring1 + format('%-26.26s',[drive[i].name]);
   tempstring2 := tempstring2 + format('%-26.26s',[drive[i].units]);
  end;
 // Copy temporary strings to memo component.
 MoDrivers.Lines.Strings[0] := tempstring1;
 MoDrivers.Lines.Add(tempstring2);

// If a driverfile was selected add drivers to memo component
 if driverfilename <> '' then
  begin
   OpenDriverFile(driverfilename,ModelDef.numdrive,drive,flread);
   while ReadDriverFile(temptime,ModelDef.numdrive,drive)  do
    begin
     { Read the first line of drivers storing time in temptime and drivers in
        the variable drive. }
     // Put time into temporary string
     tempstring1 := format('%-26.26s',[floattostr(temptime)]);
     // Add drivers to temporary string
     for i := 1 to ModelDef.numdrive do
      tempstring1 :=tempstring1+format('%-26.26s',[floattostr(drive[i].value)]);
     // Copy temporary string to memo component.
     MoDrivers.Lines.Add(tempstring1);
    end;
   CloseDriverFile;
  end;
 MoDrivers.Modified := False;
end;

{ Save changes made to the drivers in the memo component. }
procedure TFmNote.BtnSaveFileClick(Sender: TObject);
begin
// Set the default filename in the save dialog box to the current driverfile
 if driverfilename <> '' then
   MainForm.DlgSaveDriver.FileName := driverfilename;
// If the user chooses OK in the save dialog box
 if MainForm.DlgSaveDriver.execute then
  begin
   // Save the driver filename from the save dialog
   Driverfilename := MainForm.DlgSaveDriver.filename;
   { Save the file. Note that this function does not use the WriteDriverFile
    procedure provided in fileio.pas. This is because it is easier to save the
    file from the memo component directly then to parse the lines in the memo
    component into individual lines and then save them. }
   MoDrivers.Lines.SavetoFile(DriverFileName);
   NewDriverFile := False;
  end;
end;

{ This procedure allows the user to choose a different driverfile without having
  to exit the current form. }
procedure TFmNote.BtnChooseFileClick(Sender: TObject);
begin
 MainForm.ChooseDriver(FmNote);
  // Update the notepad form with the new driver variables
 FormActivate(BtnChooseFile);
end;

procedure TFmNote.BtnCloseClick(Sender: TObject);
begin
 if MoDrivers.Modified then
   begin
     if MessageDlg('The changes you made to the drivers are about to be lost. '
          + 'Do you want to save the driver file before proceeding?' ,
          mtWarning,[mbyes,mbno],0) = mryes then BtnSaveFileClick(BtnClose);
   end;
 FmNote.ModalResult := mrOK;
end;

end.
